# Cerberus Responsive Email Patterns

<a href="https://www.cerberusemail.com/"><img src="/docs/static/images/logo-cerberus-light.svg" alt="Cerberus logo" width="148" height="93" align="left" hspace="10" vspace="6"></a>

Coding regular emails is hard enough by itself. Making them responsive and accessible shouldn’t add to the headache. A few simple, but solid patterns are all that’s needed to optimize emails for small screens and assistive technologies.

**That’s what Cerberus is.**

It’s just a few responsive email patterns that go a long way. The code blocks are compartmentalized so that they may be used, combined, and nested to build an email.

Each template is annotated and has good support among popular email clients.

## **[Learn More and See Examples](https://www.cerberusemail.com/)** ##

## Contents

**`cerberus-fluid.html`** - Good for simple layouts such as transactional and single column emails.

**`cerberus-responsive.html`** - Good for more complicated, shape-shifting email layouts that work on _some_ mobile clients.

**`cerberus-hybrid.html`** - This template uses a hybrid approach to reconfigure the layout for different screen sizes for email clients regardless of media query support.

## Author

👋 I’m Ted Goas, the core author and maintainer. I’m a product designer & front-end developer with a soft spot for HTML emails. Some day I'd love to combine my professional craft and hobby to work on an email platform.
[@tedgoas](https://twitter.com/TedGoas) § [TedGoas.com](https://www.tedgoas.com/)

## License

Let’s go with something simple and permissive, shall we?

[The MIT License (MIT)](http://choosealicense.com/licenses/mit/).

Copyright (c) Ted Goas

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

## More Email Templates

If you’d prefer something that’s ready out of the box, I vouch for [htmlemail.io’s responsive email templates](https://gumroad.com/a/29078643). They’re fully tested and ready for your ESP or codebase.
